let $$ = require('./debug')({ debug: 'cache', path: module.id });

/* eslint-disable indent */
/**
 * Returns an array of objects representing the call stack.
 * @returns {Array} An array of objects representing the call stack.
 */
function stack(out) {
  let trace = {},
    stack = null;
  let regex = /^\sat\s(\S+):(\d+)(\s\((\S+)\)|)/;

  // try { throw new Error();}
  // catch(e) { stack = e.stack; }

  Error.captureStackTrace(trace);

  stack = trace.stack;
  let stackObjectArray = stack
    .split('\n')
    .slice(1, -1)
    .map(line => {
      let match = line.match(regex);
      if (match)
        return {
          module: match[1],
          line: match[2],
          function: match[4],
        };
    });

  switch (out) {
    case 'text':
      return stackObjectArray
        .slice(1)
        .map(entry => {
          return (
            entry && '{0}:{1} {2}'.format(entry.module, entry.line, entry.function ? '(' + entry.function + ')' : '')
          );
        })
        .join('\n');
    case 'raw':
      return stack;
    default:
      return stackObjectArray;
  }
}

// ------------------------------------------------------

/**
 * Logs a message to the console with additional information about the calling module and function/line number.
 * @param {string} msg - The message to log.
 */
// eslint-disable-next-line no-unused-vars
function trace(msg) {
  let caller = stack()[1];
  let module = caller.module.replace('.js', '');
  let where = typeof caller.function !== 'undefined' ? caller.function : caller.line;

  let args = [module + '[' + where + ']'];
  let out = $$.debug;

  // let args = [ module+'::'+where ];
  // let out = console.log;

  for (let i = 0; i < arguments.length; i++) args.push(arguments[i]);

  out.apply(out, args);
}

module.exports = {
  trace: trace,
  stack: stack,
};
